--[[

   3D Torches - modifyed by babe223, 4aiman, yves_de_beck

   This MOD add animated Torches in 3D. (Torches standing on ground, hanging on wall or ceiling)

   Copyrights 2013:
   - Idea and Textures for Wall Side Torches, fire animation for all torches by tonyka
   - Texture and nodebox models for wall side and hanging ceiling torches by yves_de_beck
   - Scribt to decide placing torches by 4aiman

]]--


-- Decide Scribt for placing torches
------------------------------------

minetest.register_on_placenode(function (pos, newnode, placer, oldnode, itemstack)
	-- minetest.chat_send_all(oldnode.name .. " was replaced with " .. newnode.name .. " at " .. minetest.serialize(pos))
	pos.y = pos.y+1
	local nodeover = minetest.env:get_node(pos)
	local name2 = nodeover.name
	pos.y = pos.y-2
	local nodeunder = minetest.env:get_node(pos)
	local name = nodeunder.name
	-- minetest.chat_send_all("A node under that is at " .. minetest.serialize(pos) .. " and that is " .. name)
	if name ~= "air" and newnode.name == "default:torch" then
		if name ~= "torches:torch_bottom" and name ~= "default:torch" then
		pos.y = pos.y+1
		minetest.env:remove_node(pos)
		pos.y = pos.y+1
		minetest.env:place_node(pos, {name="torches:torch_bottom"})
		return
		end
	end
	if name2 ~= "air" and newnode.name == "default:torch" then
		if name2 ~= "default:torch" then
		if name2 ~= "torches:torch_ceiling" then
		if name == "air" or name == "default:torch" or name == "torches:torch_bottom"then
		pos.y = pos.y+1
		minetest.env:remove_node(pos)
		pos.y = pos.y+1
		minetest.env:place_node(pos, {name="torches:torch_ceiling"})
		return
		end
		end
		end
	end
end
)


-- TORCH
--------
		minetest.register_node("torches:torch_bottom",
			{ description = 'Torch Floor',
			drawtype = "nodebox",
			tiles = {
				"torch_n.png",
				"torch_u.png",
				{ name="torch_anim.png",
				animation={
					type="vertical_frames",
					aspect_w=40,
					aspect_h=40,
					length=1.0
					}
				}
			},
			inventory_image = "inv_torch_bottom.png",
			 paramtype = 'light',
			 node_box = {
				type = "fixed",
				fixed = {

					--torch
					{-0.05,-0.5,-0.05,0.05,0,0.05},

					--fire
					{-0.1,0,-0.1, 0.1,0.05,0.1},
					{-0.15,0.05,-0.15, 0.15,0.15,0.15},
					{-0.1,0.15,-0.1, 0.1,0.25,0.1},
					{-0.05,0.25,-0.05, 0.05,0.35,0.05},
				},
			},
			sunlight_propagates = true,
			walkable = false,
			light_source = 1000000,
			selection_box = {
				type = "fixed",
				fixed = {-0.15,-0.5,-0.15,0.15,0.35,0.15},
			},
			groups = {choppy=2,dig_immediate=3,flammable=1},
			drop = 'default:torch'
		})

-- TORCH ON WALL
----------------
		minetest.register_node(":default:torch",
			{ description = 'Torch Wall',
			drawtype = "nodebox",
			tiles = {
				"torch_s.png",
				"torch_i.png",
				{ name="torch_anim.png",
				animation={
					type="vertical_frames",
					aspect_w=40,
					aspect_h=40,
					length=1.0
					}
				}
			},
			inventory_image = "inv_torch.png",
			 paramtype = 'light',
			 paramtype2 = "facedir",
			 node_box = {
				type = "fixed",
				fixed = {

					--torch
					{-0.05,-0.45,0.45, 0.05,-0.35,0.5},
					{-0.05,-0.35,0.4, 0.05,-0.25,0.5},
					{-0.05,-0.25,0.35, 0.05,-0.15,0.45},
					{-0.05,-0.15,0.3, 0.05,-0.05,0.4},
					{-0.05,-0.05,0.25, 0.05,0,0.35},

					--fire
					{-0.1,0,0.2, 0.1,0.05,0.4},
					{-0.15,0.05,0.15, 0.15,0.15,0.45},
					{-0.1,0.15,0.2, 0.1,0.25,0.4},
					{-0.05,0.25,0.25, 0.05,0.35,0.35},
				},
			},
			sunlight_propagates = true,
			walkable = false,
			light_source = 1000000,
			selection_box = {
				type = "fixed",
				fixed = {-0.15, -0.45, 0.15, 0.15,0.35, 0.5},
			},
			groups = {choppy=2,dig_immediate=3,flammable=1},
			drop = 'default:torch'
		})

-- TORCH ON CEILING
-------------------
		minetest.register_node("torches:torch_ceiling",
			{ description = 'Torch Floor',
			drawtype = "nodebox",
			tiles = {
				"torch_n2.png",
				"torch_u2.png",
				{ name="torch_anim2.png",
				animation={
					type="vertical_frames",
					aspect_w=40,
					aspect_h=40,
					length=1.0
					}
				}
			},
			inventory_image = "inv_torch_ceiling.png",
			 paramtype = 'light',
			 node_box = {
				type = "fixed",
				fixed = {

					--frame plate down
					{-0.3,-0.25,-0.3,0.3,-0.2,0.3},
					--frame sticks
					{-0.3,-0.2,-0.3,-0.2,0.35,-0.2},
					{-0.3,-0.2,0.2,-0.2,0.35,0.3},
					{0.2,-0.2,-0.3,0.3,0.35,-0.2},
					{0.2,-0.2,0.2,0.3,0.35,0.3},
					--frame plate up
					{-0.3,0.35,-0.3,-0.2,0.4,0.3},
					{0.2,0.35,-0.3,0.3,0.4,0.3},
					{-0.2,0.35,-0.3,0.2,0.4,-0.2},
					{-0.2,0.35,0.2,0.2,0.4,0.3},
					--holder
					{-0.075,0.4,-0.25,0.075,0.45,0.25},
					{-0.075,0.45,-0.075,0.075,0.5,0.075},
					--fuel
					{-0.05,-0.2,-0.15,0.05,0,0.15},
					{-0.15,-0.2,-0.05,0.15,0,0.05},
					{-0.115,-0.2,-0.115,0.115,0,0.115},
					--fire
					{-0.1,0,-0.1, 0.1,0.05,0.1},
					{-0.15,0.05,-0.15, 0.15,0.15,0.15},
					{-0.1,0.15,-0.1, 0.1,0.25,0.1},
					{-0.05,0.25,-0.05, 0.05,0.35,0.05},
				},
			},
			sunlight_propagates = true,
			walkable = false,
			light_source = 1000000,
			selection_box = {
				type = "fixed",
				fixed = {-0.3,-0.25,-0.3,0.3,0.5,0.3},
			},
			groups = {choppy=2,dig_immediate=3,flammable=1},
			drop = 'default:torch'
		})